	subroutine ASSEMBLE(iout, idbg, Ne, Nn, Nd, NnNd, &
			vA, vL, vB, vQc1, vQd1, &
			rA, rL, rB, rQc1, rQd1, &
			cA, cL, cB, cQc1, cQd1, &
			lastA, lastL, lastB, lastQc1, lastQd1, &
			Ae, Le, Be, Qce1, Qde1, ie, nmat, e)
! assemble arrays

	implicit none
	integer iout, idbg
	integer Ne, Nn, Nd, NnNd		! array parameters
	integer lastA, lastL, lastB, lastQc1, lastQd1
	real*8 Ae(2,2), Le(2,2), Be(2,2)	! element arrays
	real*8 Qce1(2,2), Qde1(2,2)		! element arrays
	integer ie(Ne,3)			! global connectivity array
	integer nmat(Nn,0:Nd)			! global nodal materials array
	integer rA (Nn+1), rL (Nn+1), rB(Nn+1)! global  arrays (compact rows)
	integer cA (NnNd), cL (NnNd), cB(NnNd)! global  arrays (compact columns)
	integer rQc1(Nn+1), rQd1(Nn+1)		! global  arrays (compact rows)
	integer cQc1(NnNd), cQd1(NnNd)		! global  arrays (compact columns)
	real*8 vA (NnNd), vL (NnNd), vB(NnNd)	! global  arrays (compact values)
	real*8 vQc1(NnNd), vQd1(NnNd)		! global  arrays (compact values)
	integer e

	integer i, j

!	write(idbg,'(a)') ' --- ASSEMBLE ---'	! ### TEMPORARY ###

! assemble rank 2 sparse arrays
	do i = 1,2
	  do j = 1,2
	    call ASSEMBLE2(iout, idbg, Nn, NnNd, lastA, vA, cA, rA, &
			ie(e,i), ie(e,j), Ae(i,j), 1)
	    call ASSEMBLE2(iout, idbg, Nn, NnNd, lastL, vL, cL, rL, &
			ie(e,i), ie(e,j), Le(i,j), 1)
	    call ASSEMBLE2(iout, idbg, Nn, NnNd, lastB, vB, cB, rB, &
			ie(e,i), ie(e,j), Be(i,j), 1)
	  enddo		! j
	enddo		! i

! average rank 2 sparse arrays
	do i = 1,2
	  do j = 1,2
	    call ASSEMBLE2(iout, idbg, Nn, NnNd, lastQc1, vQc1, cQc1, rQc1, &
		ie(e,i), ie(e,j), Qce1(i,j), nmat(ie(e,i),0))	! advection  comp. 1
	    call ASSEMBLE2(iout, idbg, Nn, NnNd, lastQd1, vQd1, cQd1, rQd1, &
		ie(e,i), ie(e,j), Qde1(i,j), nmat(ie(e,i),0))	! dispersion comp. 1
	  enddo		! j
	enddo		! i
				
	return
	end
